﻿# Prüfen der Ereignisse auf den DCs
$DCList = Get-ADDomainController | Sort-Object Name | Select-Object Name
Write-Host
Write-Host "Rufe die Ereignisse 5719 und 5783 von den DCs der letzten 12 Stunden ab." -ForegroundColor Gray
foreach ($DC in $DCList) {
try{
    echo $DC.name
    $Event = Get-WinEvent -ComputerName $DC.name -FilterHashTable @{LogName="System";StartTime=((get-date).addhours(-12));id='5719','5783'} -ErrorAction Stop | foreach {[string]$_.timecreated + "`t" + [string] $_.id + "`n"  + $_.ProviderName + "`n" + $_.message + "`n"}
    Write-Host "$Event" -ForegroundColor Red 
    }
    Catch{Write-Host "Keine Einträge gefunden" -ForegroundColor Green
		Write-Host}
}

# Prüfen der sicheren Verbindung zu den DCs
Start-Sleep -Seconds 2
Write-Host
Write-Host "Testen des sicheren Kanals (Secure Channel) zu den DCs in der Domäne dwp.local" -ForegroundColor Gray
foreach ($DC in $DCList) {
try{
	echo $DC.name
	$Test = Test-ComputerSecureChannel -ErrorAction Stop | Out-String -Stream
	Write-Host "$Test" -ForegroundColor Yellow 
	}
	Catch{Write-Host "Der Secure Channel Test ist für diesen Server/Workstation fehlgeschlagen" -ForegroundColor Red}
}
If ($Test -eq $false)
{

# Sichere Verbindung reparieren
Write-Host "Die Reparatur der sicheren Verbindung wird versucht" -ForegroundColor Yellow 
$Rep = Test-ComputerSecureChannel -Repair

If ($Rep -eq $true)
{
Write-Host "Die Reparatur war erfolgreich" -ForegroundColor Green
}}